# ![!](gui/images/icon32x32.png "project eliza") project eliza

## What is it?

A third party tool for Elite Dangerous explorers, which is all about your personal discoveries. Especially for linux commanders who 
can't use the likes of EDObservatory. Project eliza provides the following functions:
- after scanning a system it displays points of interest like a moon near rings
- notifications if a scanned body is somekind of personal record (like the biggest/smallest/hottest/coldest planet/star you discovered first)
- statistic functions (example: a list of the biggest A type stars you discovered...)
- display planets which are worth scanable (and an indicator if you scanned them already)
  - define your own rules for "worth scanning" planets (checks include planet type, gravity, atmosphere, temperature, mass, landable, terraformable, amount of bio signals)
- Keeps track of the potential exploration credits (per session and overall)
- can convert, rename and copy screenshots
- set a "home system" and display the current distance to it
- displays some body information in a understandable format (example: rotation period in seconds or minutes)

## Installation

Prefer mysql as a database? Then jump to the [advanced section](#advanced-configuration). Otherwise just continue. 

### Linux

The following packages are needed:
- python3-dev
- virtualenv
- libxcb-xinerama0 (maybe)

Extract archive, switch in the new directory and:

```
make install

./run.sh
```

### Windows

Python 3 must be installed.

Extract archive, open a new console, navigate to the new directory and:

```
install.bat

run.bat
```

## Updating

Already running a older version of the tool? Since 0.7.0 there is no need to reimport all data in most case. Just replace all files and call the update function:

### Linux

```
make update
```

### Windows

```
update.bat
```

## Quickstart

After the installation open the settings window (Admin / Settings) and choose the directory with the journal files.

Open the database management window (Admin / Database management) and click "Create Database". This will read all your journal files and build the necessary database.
It can take a long time, depending how many journal files exist. But you can stop and restart the import.

If the database is build, switch to the "Discovery" tab". Start Elite Dangerous and begin exploring.

## Advanced Configuration {#advanced-configuration}

To directly start with a mysql database, edit the file __config/config.ini__ before running the installation script.
Add your mysql connection data in "Mysql" section and set "DatabaseType" to mysql.

```
[Database]
DatabaseType = mysql

[Mysql]
Hostname = my_hostname
Username = my_username
Password = my_password
DbName = my_database
Port = 3306
```

## Credits

 - project-eliza: commander timeagent
 - logo: commander Dotperinch
 - test support: commander Ozzie J. Issacs & commander Dotperinch
 - calculation formula for scans: commander MattG (https://forums.frontier.co.uk/threads/exploration-value-formulae.232000/)
 - vista genomics prices: cannon science (https://canonn.science/codex/vista-genomics-price-list/)
 - galaxy image: ESA, CC BY-SA 3.0 <https://creativecommons.org/licenses/by-sa/3.0>, via Wikimedia Commons (https://commons.wikimedia.org/wiki/File:Milkyway_as_a_flocculent_spiral_galaxy.png)
 

