from package.WorthScanning.Rule import Rule
from package.WorthScanning.Response import Response
from package.Helper.ClassLoader import ClassLoader
from package.Datareader.RuleReader import RuleReader


class Scanner:
    def __init__(self):
        self.rules = []
        self.reader = RuleReader()

    def init(self):
        self.rules = []
        rules = self.reader.getAllRules()
        for rule in rules:
            tmpRule = Rule(rule['id'], rule['name'])
            tmpRule = self.addChecksToRule(tmpRule)

            if tmpRule.hasChecks():
                self.rules.append(tmpRule)

    def addChecksToRule(self, rule):
        packageName = "package.WorthScanning.Checker."

        checkData = self.reader.getChecksForRule(rule.getId())
        for data in checkData:
            checkName = "Check" + data['field'][0].upper() + data['field'][1:]
            package = packageName + checkName

            obj = ClassLoader.getClass(package, checkName)
            obj.init(data['value'], data['operator'])

            rule.addCheck(obj)

        return rule

    def isWorthScanning(self, planet):
        for rule in self.rules:
            result = rule.apply(planet)
            if result:
                return Response(rule.getName(), True)

        return Response("", False)
