class Rule:
    def __init__(self, id, name):
        self.id = id
        self.name = name
        self.checks = []

    def getId(self):
        return self.id

    def getName(self):
        return self.name

    def addCheck(self, check):
        self.checks.append(check)

    def apply(self, planet):
        for check in self.checks:
            result = check.check(planet)
            if not result:
                return False

        return True

    def hasChecks(self):
        return len(self.checks) > 0
