from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators
from package.Elite.PlanetTypes import PlanetTypes


class CheckType(AbstractCheck):
    def check(self, planet):
        if not planet.isPlanet():
            return False

        if self.operator == Operators.OPERATOR_EQUALS:
            return planet.getType() == self.value
        elif self.operator == Operators.OPERATOR_NOT_EQUALS:
            return planet.getType() != self.value
        else:
            return False

    def getInternalFieldId(self):
        return "type"

    def getOperators(self):
        return [Operators.OPERATOR_EQUALS, Operators.OPERATOR_NOT_EQUALS]

    def getValueType(self):
        return "dropdown"

    def getCheckOptions(self):
        options = []
        for key in PlanetTypes.TYPES:
            options.append(PlanetTypes.TYPES[key])

        return options
