from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators


class CheckTerraformable(AbstractCheck):
    def check(self, planet):
        if not planet.isPlanet():
            return False

        if self.value == "1" and planet.isTerraformable():
            return True
        elif self.value == "0" and not planet.isTerraformable():
            return True
        else:
            return False

    def getInternalFieldId(self):
        return "terraformable"

    def getOperators(self):
        return [Operators.OPERATOR_EQUALS]

    def getValueType(self):
        return "dropdown"

    def getCheckOptions(self):
        return [0, 1]
