from decimal import *
from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators


class CheckTemperature(AbstractCheck):
    def check(self, planet):
        if self.operator == Operators.OPERATOR_GREATER:
            return planet.getTemperature() > Decimal(self.value)
        elif self.operator == Operators.OPERATOR_SMALLER:
            return planet.getTemperature() < Decimal(self.value)
        elif self.operator == Operators.OPERATOR_EQUALS:
            return planet.getTemperature() == Decimal(self.value)

        return False

    def getInternalFieldId(self):
        return "temperature"

    def getOperators(self):
        return [Operators.OPERATOR_GREATER, Operators.OPERATOR_SMALLER, Operators.OPERATOR_EQUALS]

    def getValueType(self):
        return "text"

    def getRegex(self):
        return '^[0-9.]+$'
