from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators


class CheckRings(AbstractCheck):
    def check(self, planet):
        if self.operator == Operators.OPERATOR_EQUALS:
            if self.value == "None":
                if len(planet.getRings()) == 0:
                    return True
            elif self.value == "Any":
                if len(planet.getRings()) > 0:
                    return True
            else:
                # check a certain ring type
                for ring in planet.getRings():
                    if self.value == ring.getType():
                        return True

        return False

    def getInternalFieldId(self):
        return "rings"

    def getOperators(self):
        return [Operators.OPERATOR_EQUALS]

    def getValueType(self):
        return "dropdown"

    def getCheckOptions(self):
        options = [
            "None",
            "Any",
            "eRingClass_Icy",
            "eRingClass_MetalRich",
            "eRingClass_Rocky",
            "eRingClass_Metalic",
        ]

        return options
