from decimal import *
from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators


class CheckMass(AbstractCheck):
    def check(self, planet):
        if not planet.isPlanet():
            return False

        if self.operator == Operators.OPERATOR_GREATER:
            return planet.getMass() > Decimal(self.value)
        elif self.operator == Operators.OPERATOR_SMALLER:
            return planet.getMass() < Decimal(self.value)

        return False

    def getInternalFieldId(self):
        return "mass"

    def getOperators(self):
        return [Operators.OPERATOR_GREATER, Operators.OPERATOR_SMALLER]

    def getValueType(self):
        return "text"

    def getRegex(self):
        return '^[0-9]+$'
