from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators


class CheckLandable(AbstractCheck):
    def check(self, planet):
        if not planet.isPlanet():
            return False

        if self.operator == Operators.OPERATOR_EQUALS:
            testvalue = True
            if self.value == "0":
                testvalue = False

            return planet.isLandable() == testvalue
        else:
            return False

    def getInternalFieldId(self):
        return "landable"

    def getOperators(self):
        return [Operators.OPERATOR_EQUALS]

    def getValueType(self):
        return "dropdown"

    def getCheckOptions(self):
        return [0, 1]
