from decimal import *
from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
from package.Elite.Enum import EARTH_GRAVITY
import package.WorthScanning.Operators as Operators


class CheckGravity(AbstractCheck):
    def check(self, planet):
        if not planet.isPlanet():
            return False

        if self.operator == Operators.OPERATOR_GREATER:
            return planet.getGravity() > self.transformValue()
        elif self.operator == Operators.OPERATOR_SMALLER:
            return planet.getGravity() < self.transformValue()

        return False

    def transformValue(self):
        return Decimal(float(self.value) * EARTH_GRAVITY)

    def getInternalFieldId(self):
        return "gravity"

    def getOperators(self):
        return [Operators.OPERATOR_GREATER, Operators.OPERATOR_SMALLER]

    def getValueType(self):
        return "text"

    def getRegex(self):
        return '^[0-9.]+$'
