from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators


class CheckGeosignals(AbstractCheck):
    def check(self, planet):
        if not planet.isPlanet():
            return False

        return int(planet.getGeoSignalCount()) > int(self.value)

    def getInternalFieldId(self):
        return "geosignals"

    def getOperators(self):
        return [Operators.OPERATOR_GREATER]

    def getValueType(self):
        return "text"

    def getRegex(self):
        return '^[0-9.]+$'
