from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators


class CheckBiosignals(AbstractCheck):
    def check(self, planet):
        if not planet.isPlanet():
            return False

        return int(planet.getBioSignalCount()) > int(self.value)

    def getInternalFieldId(self):
        return "biosignals"

    def getOperators(self):
        return [Operators.OPERATOR_GREATER]

    def getValueType(self):
        return "text"

    def getRegex(self):
        return '^[0-9.]+$'
