from package.WorthScanning.Checker.AbstractCheck import AbstractCheck
import package.WorthScanning.Operators as Operators


class CheckAtmosphere(AbstractCheck):
    def check(self, planet):
        if not planet.isPlanet():
            return False

        if self.operator == Operators.OPERATOR_EQUALS:
            if self.value == "None":
                return (planet.getAtmosphereType() == self.value) or (planet.getAtmosphereType() is None)
            elif self.value == "Any":
                return (planet.getAtmosphereType() != "None") and (planet.getAtmosphereType() is not None)
            else:
                return planet.getAtmosphereType() == self.value
        else:
            return False

    def getInternalFieldId(self):
        return "atmosphere"

    def getOperators(self):
        return [Operators.OPERATOR_EQUALS]

    def getValueType(self):
        return "dropdown"

    def getCheckOptions(self):
        options = [
            "None",
            "Any",
            "Ammonia",
            "Argon",
            "ArgonRich",
            "CarbonDioxide",
            "Helium",
            "Methane",
            "Nitrogen",
            "Neon",
            "NeonRich",
            "Oxygen",
            "SilicateVapour",
            "SulphurDioxide",
            "Water",
        ]

        return options
