from abc import ABC, abstractmethod


class AbstractCheck(ABC):
    def __init__(self):
        self.value = None
        self.operator = None

    def init(self, value, operator):
        self.value = value
        self.operator = operator

    def getRegex(self):
        return None

    @abstractmethod
    def check(self, planet):
        pass

    @abstractmethod
    def getInternalFieldId(self):
        pass

    @abstractmethod
    def getOperators(self):
        pass

    @abstractmethod
    def getValueType(self):
        pass
