from PyQt5 import QtWidgets, uic, QtCore, QtGui
from PyQt5.QtCore import QSettings, QPoint
from PyQt5.QtCore import QCoreApplication
from package.Config.ConfigManager import ConfigManager
from package.Datareader.SpecialSearch import SpecialSearch
from package.Ui.Models.TableSpecialSearch import TableSpecialSearch


class SpecialSearchWindow(QtWidgets.QWidget):
    closeSignal = QtCore.pyqtSignal()
    openSystemWindowSignal = QtCore.pyqtSignal(object)

    def __init__(self):
        super(SpecialSearchWindow, self).__init__()
        self.specialSearch = SpecialSearch()
        self.specialSearchModel = None

        self.trans = QtCore.QTranslator(self)
        language = ConfigManager.getConfigValue("ui_language")
        self.trans.load("specialSearchWindow_" + language + ".qm", "translations")
        QtWidgets.QApplication.instance().installTranslator(self.trans)

        uic.loadUi('gui/specialSearchWindow.ui', self)

        # restore window position
        self.settings = QSettings('timeagent', 'eliza-specialsearch')
        self.move(self.settings.value("pos", QPoint(50, 50)))

    def closeEvent(self, a0: QtGui.QCloseEvent) -> None:
        """
        Closes the Window and emits a signal containing the actions that should be performed by the main window
        :return: None
        """
        self.settings.setValue("pos", self.pos())
        self.closeSignal.emit()
        self.close()

    def init(self) -> None:
        """
        init all elements
        :return:
        """
        self.dropdownSearchType.addItem(
            QCoreApplication.translate("Additional", "hotspot_tritium"),
            "hotspot_tritium"
        )
        self.dropdownSearchType.addItem(
            QCoreApplication.translate("Additional", "stellar_phenomena"),
            "stellar_phenomena"
        )

        self.searchButton.clicked.connect(self.search)
        self.resultTable.doubleClicked.connect(self.tableDoubleClicked)
        self.resultTable.setShowGrid(False)

    def search(self) -> None:
        """
        Trigger the search
        :return: None
        """
        searchType = self.dropdownSearchType.currentData()
        own = self.checkBoxOwnDiscoveriesOnly.isChecked()

        if searchType == "stellar_phenomena":
            result = self.specialSearch.searchStellarPhenomena(own)
        elif searchType == "hotspot_tritium":
            result = self.specialSearch.searchHotSpot(own)

        self.fillStatisticsTable(result)

    def fillStatisticsTable(self, data) -> None:
        """
        Add search data to table model
        :param data: dict
        :return: None
        """
        # set model
        self.specialSearchModel = TableSpecialSearch(data)

        self.resultTable.setModel(None)
        self.resultTable.setModel(self.specialSearchModel)

        # set column sizes
        header = self.resultTable.horizontalHeader()
        for x in range(len(header)):
            if x == 0:
                header.setSectionResizeMode(x, QtWidgets.QHeaderView.Stretch)
            else:
                header.setSectionResizeMode(x, QtWidgets.QHeaderView.ResizeToContents)

    def tableDoubleClicked(self, index) -> None:
        """
        Emit the signal if a table row is double clicked
        :param index:
        :return: None
        """
        data = self.resultTable.model().getDataForIndex(index)
        self.openSystemWindowSignal.emit(data)
