from PyQt5 import QtWidgets, uic, QtCore, QtGui
from PyQt5.QtCore import QCoreApplication
from PyQt5.QtCore import QSettings, QPoint
from package.Config.ConfigManager import ConfigManager
from package.Ui.Element.CheckerEntry import CheckerEntry
from package.Ui.Windows.CheckerConfigWindow import CheckerConfigWindow


class ManageCheckerWindow(QtWidgets.QWidget):
    closeSignal = QtCore.pyqtSignal()

    def __init__(self):
        super(ManageCheckerWindow, self).__init__()
        self.checkerCheckboxes = {}
        self.checkerSettingsChanged = False
        self.checkerConfigWindow = None

        self.trans = QtCore.QTranslator(self)
        language = ConfigManager.getConfigValue("ui_language")
        self.trans.load("manageCheckerWindow_" + language + ".qm", "translations")
        QtWidgets.QApplication.instance().installTranslator(self.trans)
        uic.loadUi('gui/manageCheckerWindow.ui', self)

        # restore window position
        self.settings = QSettings('timeagent', 'eliza-managecheckerwindow')
        self.move(self.settings.value("pos", QPoint(50, 50)))

    def init(self):
        """
        Gets all checker from the db and displays them in a grid
        :return:
        """
        allChecker = ConfigManager.getChecker(True)

        row = 0
        column = 0
        for checker in allChecker:
            active = False
            if checker['active'] == 1:
                active = True

            self.checkerCheckboxes[checker["id"]] = CheckerEntry(checker["id"], checker["name"], active)
            self.checkerCheckboxes[checker["id"]].checkerChangedSignal.connect(self.checkerChanged)
            self.checkerCheckboxes[checker["id"]].checkerConfigButtonSignal.connect(self.openCheckerConfigWindow)

            self.settingsGridChecker.addWidget(self.checkerCheckboxes[checker["id"]], row, column)

            column += 1
            if column == 3:
                column = 0
                row += 1

    def closeEvent(self, a0: QtGui.QCloseEvent) -> None:
        """
        Closes the Window and emits a signal. if checkers were changed open a message box
        :return: None
        """
        self.settings.setValue("pos", self.pos())

        if self.checkerSettingsChanged:
            error_dialog = QtWidgets.QErrorMessage(self)
            error_dialog.setWindowModality(QtCore.Qt.WindowModal)
            error_dialog.showMessage(QCoreApplication.translate("MainUi", "restart_application"))
            error_dialog.exec_()

        self.closeSignal.emit()
        self.close()

    def checkerChanged(self):
        """
        Triggerd from the CheckerEntry Element if a checkbox was modified.
        :return: None
        """
        self.checkerSettingsChanged = True

    def openCheckerConfigWindow(self, checkerName: str) -> None:
        """
        Opens a new Checker config window
        :param checkerName: string
        :return: None
        """
        self.checkerConfigWindow = CheckerConfigWindow(checkerName)
        self.checkerConfigWindow.exec()
