import locale
from PyQt5 import QtWidgets, uic, QtCore
from package.Config.ConfigManager import ConfigManager
from package.Observer.SessionStatisticHandler import SessionStatisticHandler
from package.Datareader.FlightlogReader import FlightlogReader
from package.Datareader.OrganicSamplesReader import OrganicSamplesReader
from package.Datareader.PlanetReader import PlanetReader


class FlightStatisticWindow(QtWidgets.QWidget):
    def __init__(self):
        super(FlightStatisticWindow, self).__init__()

        self.trans = QtCore.QTranslator(self)
        language = ConfigManager.getConfigValue("ui_language")
        self.trans.load("flightStatWindow_" + language + ".qm", "translations")
        QtWidgets.QApplication.instance().installTranslator(self.trans)
        uic.loadUi('gui/flightStatWindow.ui', self)

    def init(self):
        # session data
        sessionStat = SessionStatisticHandler.getInstance()
        sessionJumps = str(sessionStat.getJumps())
        sessionDistance = locale.format_string('%.2f', sessionStat.getDistance(), True) + " LY"
        sessionFuel = locale.format_string('%.2f', sessionStat.getFuelUsed(), True) + " T"

        # overall data
        reader = FlightlogReader()
        overallJumps = str(reader.getJumpCount())
        overallDistance = locale.format_string('%.2f', reader.getFullDistance(), True) + " LY"
        overallFuel = locale.format_string('%.2f', reader.getFuelUsed(), True) + " T"

        organicReader = OrganicSamplesReader()
        overallOrganicScans = organicReader.getFullScanCount()

        planetReader = PlanetReader()
        overallDetailScans = planetReader.getDetailScanCount()

        self.labelSessionJumps.setText(sessionJumps)
        self.labelSessionDistance.setText(sessionDistance)
        self.labelSessionFuel.setText(sessionFuel)
        self.labelSessionStarsScanned.setText(str(sessionStat.getStarScanCout()))
        self.labelSessionPlanetsScanned.setText(str(sessionStat.getPlanetScanCount()))
        self.labelSessionDetailScans.setText(str(sessionStat.getDetailScanCount()))
        self.labelSessionOrganicScans.setText(str(sessionStat.getOrganicScanCount()))

        self.labelOverallJumps.setText(overallJumps)
        self.labelOverallDistance.setText(overallDistance)
        self.labelOverallFuel.setText(overallFuel)
        self.labelOverallDetailScans.setText(str(overallDetailScans))
        self.labelOverallOrganic.setText(str(overallOrganicScans))
