import re
from PyQt5 import QtWidgets, uic, QtCore, QtGui
from PyQt5.QtCore import QCoreApplication
from package.Config.ConfigManager import ConfigManager
from package.Service.RuleService import RuleService
from package.Helper.ClassLoader import ClassLoader


class CreateCheckWindow(QtWidgets.QDialog):
    checkInactiveSignal = QtCore.pyqtSignal(str)

    def __init__(self):
        super(CreateCheckWindow, self).__init__()

        self.ruleService = RuleService()
        self.operatorModel = QtGui.QStandardItemModel()
        self.dropdownValueModel = QtGui.QStandardItemModel()
        self.check = None
        self.valueField = None
        self.ruleId = None
        self.checkType = None

        self.trans = QtCore.QTranslator(self)
        language = ConfigManager.getConfigValue("ui_language")
        self.trans.load("editWorthScanningRules_" + language + ".qm", "translations")
        QtWidgets.QApplication.instance().installTranslator(self.trans)
        uic.loadUi('gui/addCheck.ui', self)

    def init(self):
        self.buttonCreateCheck.clicked.connect(self.createCheck)
        self.comboBoxOperator.setModel(self.operatorModel)

    def setRuleId(self, ruleId):
        self.ruleId = ruleId

    def setCheckType(self, checkType):
        self.checkType = checkType
        self.createCheckClass(checkType)
        self.labelCheckType.setText(QCoreApplication.translate("Form", "check_" + self.check.getInternalFieldId()))
        self.labelCheckTypeHelp.setText(QCoreApplication.translate("Form", "check_help_" + self.check.getInternalFieldId()))
        self.setOperatorOptions()
        self.setValueField()

    def createCheckClass(self, checktype):
        checkName = "Check" + checktype[0].upper() + checktype[1:]
        packageName = "package.WorthScanning.Checker." + checkName
        self.check = ClassLoader.getClass(packageName, checkName)

    def setOperatorOptions(self):
        self.operatorModel.clear()
        for option in self.check.getOperators():
            item = QtGui.QStandardItem(QCoreApplication.translate("Form", "operator_" + option.lower()))
            item.setData(option, QtCore.Qt.UserRole)
            self.operatorModel.appendRow(item)

    def setValueField(self):
        self.removeExistingValueWidget()

        if self.check.getValueType() == "dropdown":
            self.createDropDownValue()
        elif self.check.getValueType() == "text":
            self.createTextValue()

    def removeExistingValueWidget(self):
        self.valueLayout.removeWidget(self.valueField)
        self.valueField = None

    def createDropDownValue(self):
        self.dropdownValueModel.clear()

        self.valueField = QtWidgets.QComboBox()
        self.valueField.setModel(self.dropdownValueModel)

        for option in self.check.getCheckOptions():
            translation = self.getValueTranslation(option)
            item = QtGui.QStandardItem(translation)
            item.setData(option, QtCore.Qt.UserRole)
            self.dropdownValueModel.appendRow(item)

        self.valueLayout.addWidget(self.valueField)

    def getValueTranslation(self, option):
        if self.check.getInternalFieldId() == "type":
            return QCoreApplication.translate("BodyTypes", option)
        else:
            return  QCoreApplication.translate("Form", "option_" + str(option).lower())

    def createTextValue(self):
        self.valueField = QtWidgets.QLineEdit()
        self.valueLayout.addWidget(self.valueField)

    def getCheckValue(self):
        if self.check.getValueType() == "dropdown":
            return self.valueField.currentData()
        elif self.check.getValueType() == "text":
            return self.valueField.text()

    def createCheck(self):
        field = self.check.getInternalFieldId()
        operator = self.comboBoxOperator.currentData()
        value = self.getCheckValue()

        isValid = True

        # validate input for text fields
        if self.check.getValueType() == "text" and self.check.getRegex() is not None:
            regex = re.compile(self.check.getRegex())
            if not regex.search(value):
                isValid = False

        if isValid:
            self.ruleService.createCheckForRule(self.ruleId, field, value, operator)
            self.checkInactiveSignal.emit(self.checkType)
            self.close()
        else:
            self.valueField.setStyleSheet("border: 1px solid red;")
