from PyQt5 import QtCore, QtGui
from PyQt5.QtCore import Qt
from PyQt5.QtCore import QCoreApplication


class TableWorthScanning(QtCore.QAbstractTableModel):
    columnMap = {
        0: "number",
        1: "type",
        2: "distance",
        3: "isTerraformable"
    }

    def __init__(self, data):
        super(TableWorthScanning, self).__init__()
        self._data = data

    def rowCount(self, index):
        return len(self._data)

    def columnCount(self, index):
        return 3

    def getColumnNameForIndex(self, index):
        return self.columnMap[index]

    def data(self, index, role):
        mappedIndex = self.getColumnNameForIndex(index.column())
        if role == Qt.DisplayRole:
            value = self._data[index.row()][mappedIndex]
            if mappedIndex == "type":
                return QCoreApplication.translate("BodyTypes", value)
            else:
                return value

        if role == Qt.DecorationRole and mappedIndex == "number":
            if self._data[index.row()]['detailScan'] is True:
                return QtGui.QColor(112, 201, 103)
            else:
                return QtGui.QColor(201, 103, 112)

        if role == Qt.DecorationRole and mappedIndex == "type":
            if self._data[index.row()]['isTerraformable'] is True:
                return QtGui.QIcon('gui/images/icons/terraformable_small.png')

        if role == Qt.ToolTipRole and mappedIndex == "type" and self._data[index.row()]['isTerraformable'] is True:
            return QCoreApplication.translate("Systemview", "terraformable")

    def setData(self, index, value):
        mappedIndex = self.getColumnNameForIndex(index.column())
        self.__data[index.row()][mappedIndex] = value
        return True

    def insertRows(self, position, rows, item, parent=QtCore.QModelIndex()):
        self.beginInsertRows(QtCore.QModelIndex(), len(self.__data), len(self.__data)+1)
        self.__data.append(item)
        self.endInsertRows()
        return True
