import locale
from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.QtCore import Qt
from decimal import *


class TableStatistics(QtCore.QAbstractTableModel):
    columnMapping = {}
    headerLabels = []

    def __init__(self, data):
        super(TableStatistics, self).__init__()
        self.generateMapping(data)
        self._data = data

    def generateMapping(self, data):
        self.headerLabels.clear()
        self.columnMapping.clear()
        counter = 0
        if len(data) > 0:
            for key in data[0]:
                self.headerLabels.append(key)
                self.columnMapping[counter] = key
                counter += 1

    def rowCount(self, index=None):
        return len(self._data)

    def columnCount(self, index=None) -> int:
        if len(self._data) > 0:
            return len(self._data[0]) - 2
        else:
            return 0

    def getColumnNameForIndex(self, index):
        return self.columnMapping[index]

    def data(self, index, role=None):
        mappedIndex = self.getColumnNameForIndex(index.column())
        value = self._data[index.row()][mappedIndex]
        if role == Qt.DisplayRole:
            if isinstance(value, Decimal):
                return locale.format_string('%.4f', value, True)
            else:
                return self._data[index.row()][mappedIndex]

#        if role == Qt.DecorationRole and mappedIndex == "number":
#            if self._data[index.row()]['detailScan'] is True:
#                return QtGui.QColor(112, 201, 103)
#            else:
#                return QtGui.QColor(201, 103, 112)

    def setData(self, index, value, role=QtCore.Qt.DisplayRole):
        mappedIndex = self.getColumnNameForIndex(index.column())
        self._data[index.row()][mappedIndex] = value
        return True

    def insertRows(self, position, rows, item, parent=QtCore.QModelIndex()):
        self.beginInsertRows(QtCore.QModelIndex(), len(self.__data), len(self.__data)+1)
        self.__data.append(item)
        self.endInsertRows()
        return True

    def headerData(self, section, orientation, role=Qt.DisplayRole):
        if len(self._data) == 0:
            return None

        if role == Qt.DisplayRole and orientation == Qt.Horizontal:
            return self.headerLabels[section]
        elif role == Qt.DisplayRole and orientation == Qt.Vertical:
            return section + 1

    def flags(self, index):
        return QtCore.Qt.ItemIsEnabled

    def getDataForIndex(self, index) -> dict:
        """
        Returns all internal data for a given table index
        :param index:
        :return: dict
        """
        return self._data[index.row()]
