import locale
from PyQt5 import QtCore, QtGui, QtWidgets
from PyQt5.QtCore import Qt
from PyQt5.QtCore import QCoreApplication
from decimal import *


class TableSpecialSearch(QtCore.QAbstractTableModel):
    columnMapping = {
        0: "specialsearch_system",
        1: "specialsearch_detail",
        2: "specialsearch_distance",
    }

    def __init__(self, data):
        super(TableSpecialSearch, self).__init__()
        self._data = data

    def columnCount(self, index=None):
        if len(self._data) > 0:
            return 3
        else:
            return 0

    def rowCount(self, index=None):
        return len(self._data)

    def getColumnNameForIndex(self, index):
        return self.columnMapping[index]

    def data(self, index, role=None):
        if not index.isValid():
            return None

        if index.row() >= len(self._data) or index.row() < 0:
            return None

        mappedIndex = self.getColumnNameForIndex(index.column())
        value = self._data[index.row()][mappedIndex]

        if role == Qt.DisplayRole:
            if mappedIndex == "specialsearch_distance":
                value = locale.format_string('%.4f', value, True)
                return value + " " + QCoreApplication.translate("Flightlog", "lightyear_abbr")
            else:
                return str(self._data[index.row()][mappedIndex])

    def headerData(self, section, orientation, role=Qt.DisplayRole):
        if len(self._data) == 0:
            return None

        if role == Qt.DisplayRole and orientation == Qt.Horizontal:
            return QCoreApplication.translate("Additional", self.columnMapping[section])

    def flags(self, index):
        return QtCore.Qt.ItemIsEnabled

    def getDataForIndex(self, index) -> dict:
        """
        Returns all internal data for a given table index
        :param index:
        :return: dict
        """
        return self._data[index.row()]