from PyQt5 import QtWidgets
from PyQt5.QtCore import QCoreApplication
from package.Ui.Handler.BaseHandler import BaseHandler
from package.Database.DbFactory import DbFactory
from package.Observer.CalculationHandler import CalculationHandler


class DiscoveryHandler(BaseHandler):
    def __init__(self, view):
        super().__init__(view)
        self.view = view
        self.messagebox = None

    def resetCreditsCount(self):
        self.messagebox = QtWidgets.QMessageBox()
        self.messagebox.setIcon(QtWidgets.QMessageBox.Information)
        self.messagebox.setText(QCoreApplication.translate("MainUi", "Reset Credit Count"))
        self.messagebox.setWindowTitle(QCoreApplication.translate("MainUi", "Reset"))
        self.messagebox.setStandardButtons(QtWidgets.QMessageBox.Ok | QtWidgets.QMessageBox.Cancel)
        self.messagebox.buttonClicked.connect(self.handleResetCountClick)
        self.messagebox.exec_()

    def handleResetCountClick(self, i):
        sb = self.messagebox.standardButton(i)
        if sb == QtWidgets.QMessageBox.Ok:
            self.resetData()

    def resetData(self):
        db = DbFactory.getDatabase()
        db.delete('calculation')
        db.delete('bio_calculation')

        calc = CalculationHandler.getInstance(db)
        calc.resetValues()

        self.view.lineEditDiscoverySessionValue.setText("0")
        self.view.lineEditDiscoveryTotalValue.setText("0")
        self.view.lineEditDiscoveryBioSession.setText("0")
        self.view.lineEditDiscoveryBioTotalValue.setText("0")
