from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *
from package.Helper.UiHelper import *


class SystemScanBox(QFrame):
    def __init__(self, parent=None):
        super().__init__(parent)

        self.setFrameStyle(QFrame.Panel | QFrame.Raised)
        self.setLineWidth(2)
        self.textBrowser = None

        self.init()

    def init(self) -> None:
        # main layout
        mainLayout = QVBoxLayout(self)
        mainLayout.setContentsMargins(6, 3, 6, 3)

        self.textBrowser = QTextBrowser()
        self.textBrowser.setFixedHeight(300)

        mainLayout.addWidget(self.createHeaderBox())
        mainLayout.addWidget(self.textBrowser)

    def createHeaderBox(self):
        nameTopFrame = QFrame()
        nameTopFrame.setFrameStyle(QFrame.Panel | QFrame.Raised)
        nameTopFrame.setLineWidth(1)

        topFrameLayout = QHBoxLayout(nameTopFrame)
        nameLabel = getDescLabel(
            QCoreApplication.translate("Systemview", "system_scan_result")
        )

        boldFont = QFont()
        boldFont.setBold(True)
        nameLabel.setFont(boldFont)
        topFrameLayout.addWidget(nameLabel)

        return nameTopFrame

    def clearMessages(self):
        self.textBrowser.clear()

    def addMessage(self, msg):
        self.textBrowser.append(msg)
