from PyQt5 import QtWidgets, QtGui, QtCore
from PyQt5.QtCore import QCoreApplication
from package.Elite.StarIconMap import STAR_ICON_MAP


class SystemBody(QtWidgets.QWidget):
    clickSignal = QtCore.pyqtSignal(object)

    def __init__(self, parent=None, object=None):
        super(SystemBody, self).__init__(parent)
        self.object = object
        self.labelBodyName = None
        self.labelBodyType = None
        self.labelDistance = None
        self.iconLayout = None
        self.line = None

        self.init()
        self.displayData()

        self.setCursor(QtGui.QCursor(QtCore.Qt.PointingHandCursor))

    def init(self):
        # main layout
        mainLayout = QtWidgets.QVBoxLayout(self)
        mainLayout.setContentsMargins(6, 3, 6, 3)

        # horizontal layout for the content
        hlayout = QtWidgets.QHBoxLayout()
        hlayout.setContentsMargins(0, 0, 0, 0)

        # object picture
        #if self.object.isStar():
        #    picLabel = QtWidgets.QLabel()
        #    pixmap = QtGui.QPixmap("gui/images/stars/" + self.getStarPictureName(self.object.getType()))
        #    pixmap = pixmap.scaledToHeight(50)
        #    picLabel.setPixmap(pixmap)
        #    picLabel.setAlignment(QtCore.Qt.AlignTop | QtCore.Qt.AlignLeft)
        #    picLabel.setSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
        #    hlayout.addWidget(picLabel)

        # vertical layout for content
        contentlayout = QtWidgets.QVBoxLayout()
        contentlayout.setContentsMargins(0, 0, 0, 0)

        # body name label
        self.labelBodyName = QtWidgets.QLabel(self)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.labelBodyName.sizePolicy().hasHeightForWidth())
        self.labelBodyName.setSizePolicy(sizePolicy)

        font = QtGui.QFont()
        font.setPointSize(10)
        self.labelBodyName.setFont(font)
        self.labelBodyName.setObjectName("label")
        contentlayout.addWidget(self.labelBodyName)

        # horizontal layout
        horizontalLayout = QtWidgets.QHBoxLayout()
        horizontalLayout.setObjectName("horizontalLayout")

        # body type label
        self.labelBodyType = QtWidgets.QLabel(self)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.labelBodyType.sizePolicy().hasHeightForWidth())
        self.labelBodyType.setSizePolicy(sizePolicy)

        font = QtGui.QFont()
        font.setPointSize(8)
        self.labelBodyType.setFont(font)
        self.labelBodyType.setObjectName("label_3")
        horizontalLayout.addWidget(self.labelBodyType)

        # distance label
        self.labelDistance = QtWidgets.QLabel(self)
        sizePolicy = QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Expanding, QtWidgets.QSizePolicy.Minimum)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.labelDistance.sizePolicy().hasHeightForWidth())
        self.labelDistance.setSizePolicy(sizePolicy)
        font = QtGui.QFont()
        font.setPointSize(8)
        self.labelDistance.setFont(font)
        self.labelDistance.setLayoutDirection(QtCore.Qt.LeftToRight)
        self.labelDistance.setAlignment(QtCore.Qt.AlignRight|QtCore.Qt.AlignTrailing|QtCore.Qt.AlignVCenter)
        self.labelDistance.setObjectName("labelDistance")
        horizontalLayout.addWidget(self.labelDistance)

        contentlayout.addLayout(horizontalLayout)

        # vlayout to hlayout
        hlayout.addLayout(contentlayout)
        mainLayout.addLayout(hlayout)

        # icon bar
        self.iconLayout = QtWidgets.QHBoxLayout()
        self.iconLayout.setObjectName("iconLayout")
        #self.iconLayout.setContentsMargins(25, 0, 0, 0)
        mainLayout.addLayout(self.iconLayout)

        # bottom line
        self.line = QtWidgets.QFrame(self)
        self.line.setFrameShape(QtWidgets.QFrame.HLine)
        self.line.setFrameShadow(QtWidgets.QFrame.Sunken)
        self.line.setObjectName("line")
        mainLayout.addWidget(self.line)

        self.setLayout(mainLayout)
        self.setSizePolicy(QtWidgets.QSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum))

        palette = self.palette()
        palette.setColor(QtGui.QPalette.Window, QtGui.QColor(180, 180, 180))
        self.setPalette(palette)

    def displayData(self):
        bodyTypeText = QCoreApplication.translate("BodyTypes", self.object.getType())
        if self.object.isStar():
            bodyTypeText += ' (' + self.object.getMassAsString(2) + ' Sonnenmassen)'

        self.labelBodyName.setText(self.object.getName())
        self.labelBodyType.setText(bodyTypeText)
        self.labelDistance.setText(self.object.getDistanceAsString(0))

        self.addInfoIcons()

        if self.object.isPlanet():
            self.addSsaIcons()

    def addInfoIcons(self):
        numIconsSet = 0

        # first discovered icon
        if self.object.wasDiscovered() is not True:
            picLabel = QtWidgets.QLabel()
            pixmap = QtGui.QPixmap("gui/images/icons/firstdiscovered_small.png")
            picLabel.setPixmap(pixmap)
            picLabel.setAlignment(QtCore.Qt.AlignTop | QtCore.Qt.AlignLeft)
            picLabel.setSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
            picLabel.setToolTip(QCoreApplication.translate("Systemview", "first_discovered"))
            self.iconLayout.addWidget(picLabel)
            numIconsSet += 1

        # detail scan icon
        if self.object.isPlanet() and self.object.isDetailScaned():
            picLabel = QtWidgets.QLabel()
            pixmap = QtGui.QPixmap("gui/images/icons/mapped_small.png")
            picLabel.setPixmap(pixmap)
            picLabel.setAlignment(QtCore.Qt.AlignTop | QtCore.Qt.AlignLeft)
            picLabel.setSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
            picLabel.setToolTip(QCoreApplication.translate("Systemview", "detail_scan"))
            self.iconLayout.addWidget(picLabel)
            numIconsSet += 1

        # terraformable icon
        if self.object.isPlanet() and self.object.isTerraformable():
            picLabel = QtWidgets.QLabel()
            pixmap = QtGui.QPixmap("gui/images/icons/terraformable_small.png")
            picLabel.setPixmap(pixmap)
            picLabel.setAlignment(QtCore.Qt.AlignTop | QtCore.Qt.AlignLeft)
            picLabel.setSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
            picLabel.setToolTip(QCoreApplication.translate("Systemview", "tooltip_terraformable"))
            self.iconLayout.addWidget(picLabel)
            numIconsSet += 1

        # landable icon
        if self.object.isPlanet() and self.object.isLandable():
            picLabel = QtWidgets.QLabel()
            pixmap = QtGui.QPixmap("gui/images/icons/landable_small.png")
            picLabel.setPixmap(pixmap)
            picLabel.setAlignment(QtCore.Qt.AlignTop | QtCore.Qt.AlignLeft)
            picLabel.setSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
            picLabel.setToolTip(QCoreApplication.translate("Systemview", "tooltip_landable"))
            self.iconLayout.addWidget(picLabel)
            numIconsSet += 1

        # add spacer if more than one icon is displayed
        if numIconsSet > 1:
            self.iconLayout.addStretch(1)

    def addSsaIcons(self):
        if self.object.getBioSignalCount() > 0:
            font = QtGui.QFont()
            font.setPointSize(8)

            bioLabel = QtWidgets.QLabel(
                QCoreApplication.translate("Systemview", "bio_signals_short") + " " + str(self.object.getBioSignalCount())
            )
            bioLabel.setFont(font)
            bioLabel.setAlignment(QtCore.Qt.AlignTop | QtCore.Qt.AlignRight)
            bioLabel.setSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
            bioLabel.setToolTip(QCoreApplication.translate("Systemview", "tooltip_bio_signals"))
            self.iconLayout.addWidget(bioLabel)

        if self.object.getGeoSignalCount() > 0:
            font = QtGui.QFont()
            font.setPointSize(8)

            geoLabel = QtWidgets.QLabel(
                QCoreApplication.translate("Systemview", "geo_signals_short") + " " + str(self.object.getGeoSignalCount())
            )
            geoLabel.setFont(font)
            geoLabel.setAlignment(QtCore.Qt.AlignTop | QtCore.Qt.AlignRight)
            geoLabel.setSizePolicy(QtWidgets.QSizePolicy.Minimum, QtWidgets.QSizePolicy.Minimum)
            geoLabel.setToolTip(QCoreApplication.translate("Systemview", "tooltip_geo_signals"))
            self.iconLayout.addWidget(geoLabel)

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        self.clickSignal.emit(self.object)
        self.setAutoFillBackground(True)

    def getStarPictureName(self, starType):
        if starType in STAR_ICON_MAP:
            return STAR_ICON_MAP[starType] + "_small.png"
        elif starType is not None:
            return starType[0].lower() + "_small.png"
