from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *
from package.Helper.UiHelper import *
from package.Journal.Events.Ring import Ring


class RingInfo(QGroupBox):
    def __init__(self, title: str, ring: Ring):
        super().__init__(title)
        self.ring = ring

        self.init()

    def init(self) -> None:
        # main layout
        mainLayout = QVBoxLayout(self)
        mainLayout.addLayout(self.createMainInfoGrid())

        if len(self.ring.getSsaSignales()) > 0:
            lineFrame = QFrame()
            lineFrame.setFrameShape(QFrame.HLine)
            lineFrame.setFrameShadow(QFrame.Sunken)
            mainLayout.addWidget(lineFrame)
            mainLayout.addLayout(self.createHotspotList())

        self.setLayout(mainLayout)

    def createMainInfoGrid(self) -> QGridLayout:
        # Gridbox for basic infos
        dataLayout = QGridLayout()

        #ring type
        dataLayout.addWidget(
            getDescLabel(
                QCoreApplication.translate("Systemview", "ring_type")
            ),
            0,
            0
        )

        dataLayout.addWidget(
            getContentLabel(QCoreApplication.translate("BodyTypes", self.ring.getType())),
            0,
            1
        )

        # inner radius
        dataLayout.addWidget(
            getDescLabel(
                QCoreApplication.translate("Systemview", "inner_radius")
            ),
            1,
            0
        )

        dataLayout.addWidget(
            getContentLabel(QCoreApplication.translate("BodyTypes", self.ring.getInnerRadiusAsString())),
            1,
            1
        )

        # outer radius
        dataLayout.addWidget(
            getDescLabel(
                QCoreApplication.translate("Systemview", "outer_radius")
            ),
            2,
            0
        )

        dataLayout.addWidget(
            getContentLabel(QCoreApplication.translate("BodyTypes", self.ring.getOuterRadiusAsString())),
            2,
            1
        )

        # outer radius
        dataLayout.addWidget(
            getDescLabel(
                QCoreApplication.translate("Systemview", "ring_width")
            ),
            3,
            0
        )

        dataLayout.addWidget(
            getContentLabel(QCoreApplication.translate("BodyTypes", self.ring.getRingWidthAsString())),
            3,
            1
        )

        return dataLayout

    def createHotspotList(self) -> QGridLayout:
        dataLayout = QGridLayout()

        row = 0
        col = 0
        for signal in self.ring.getSsaSignales():
            name = signal.getTypeLocalised()
            if name is None or name == "":
                name = signal.getType()

            dataLayout.addWidget(
                getDescLabel(name),
                row,
                col
            )

            col += 1

            dataLayout.addWidget(
                getContentLabel(str(signal.getCount())),
                row,
                col
            )

            col += 1
            if col > 4:
                col = 0
                row += 1

        return dataLayout
