from package.Helper.UiHelper import *
from package.Journal.Events.Planet import Planet
from package.Journal.Events.SSASignal import SSASignal


class MiscCodexBox(QGroupBox):
    def __init__(self, planet: Planet):
        super().__init__(QCoreApplication.translate("Systemview", "codex_misc"))
        self.body = planet

        self.init()

    def init(self) -> None:
        dataLayout = QGridLayout()

        self.setLayout(dataLayout)
        dataLayout.addWidget(
            getDescLabel(QCoreApplication.translate("Systemview", "codex_misc_count")),
            0,
            0
        )

        dataLayout.addWidget(
            getContentLabel(
                str(len(self.body.getCodexEntries(SSASignal.DB_TYPE_MISC)))
            ),
            0,
            1
        )

        row = 1
        for codex in self.body.getCodexEntries(SSASignal.DB_TYPE_MISC):
            dataLayout.addWidget(
                getContentLabel(
                    codex.getNameLocalised()
                ),
                row,
                0
            )
            row += 1
