from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *
from decimal import *


class MiniMap(QWidget):
    def __init__(self, destX, destY, currentX, currentY):
        super().__init__()
        self.setFixedSize(260, 260)

        self.solX = Decimal(131)
        self.solY = Decimal(198)
        self.lyPx = Decimal(0.002635983)
        self.image = 'gui/images/galaxy.png'

        self.destX = destX
        self.destY = destY
        self.currentX = currentX
        self.currentY = currentY

    def paintEvent(self, event) -> None:
        """
        Paint map
        :param event:
        :return: None
        """
        painter = QPainter(self)
        pixmap = QPixmap(self.image)
        painter.drawPixmap(self.rect(), pixmap)

        # destination position
        newx = self.solX + (self.destX * self.lyPx)
        newy = self.solY - (self.destY * self.lyPx)

        painter.setBrush(QBrush(Qt.red, Qt.SolidPattern))
        painter.drawEllipse(int(newx), int(newy), 5, 5)

        # current position
        newx = self.solX + (self.currentX * self.lyPx)
        newy = self.solY - (self.currentY * self.lyPx)

        painter.setBrush(QBrush(Qt.green, Qt.SolidPattern))
        painter.drawEllipse(int(newx), int(newy), 5, 5)
