from package.Helper.UiHelper import *
from package.Journal.Events.Planet import Planet
from package.Journal.Events.SSASignal import SSASignal


class GeoBox(QGroupBox):
    def __init__(self, planet: Planet):
        super().__init__(QCoreApplication.translate("Systemview", "tooltip_geo_signals"))
        self.body = planet

        self.init()

    def init(self) -> None:
        dataLayout = QGridLayout()

        self.setLayout(dataLayout)
        dataLayout.addWidget(
            getDescLabel(QCoreApplication.translate("Systemview", "geo_signal_count")),
            0,
            0
        )

        dataLayout.addWidget(
            getContentLabel(
                str(self.body.getGeoSignalCount())
            ),
            0,
            1
        )

        row = 1
        for codex in self.body.getCodexEntries(SSASignal.DB_TYPE_GEO):
            text = codex.getNameLocalised()
            if codex.isNewEntry():
                text += " " + QCoreApplication.translate("Systemview", "codex_new")

            dataLayout.addWidget(
                getContentLabel(text),
                row,
                0
            )
            row += 1
