from package.Helper.UiHelper import *
from package.Journal.Events.Planet import Planet
from package.Journal.Events.ScanOrganic import ScanOrganic
from package.Journal.Events.SSASignal import SSASignal


class BioBox(QGroupBox):
    def __init__(self, planet: Planet):
        super().__init__(QCoreApplication.translate("Systemview", "tooltip_bio_signals"))
        self.body = planet

        self.init()

    def init(self) -> None:
        dataLayout = QGridLayout()
        dataLayout.addWidget(
            getDescLabel(QCoreApplication.translate("Systemview", "bio_signal_count")),
            0,
            0
        )

        dataLayout.addWidget(
            getContentLabel(
                str(self.body.getBioSignalCount())
            ),
            0,
            1
        )

        dataLayout.addWidget(
            getDescLabel(QCoreApplication.translate("Systemview", "bio_signal_scanned")),
            1,
            0
        )

        dataLayout.addWidget(
            getDescLabel(QCoreApplication.translate("Systemview", "bio_signal_collected")),
            1,
            1
        )

        dataLayout.addWidget(
            getDescLabel(QCoreApplication.translate("Systemview", "codex")),
            1,
            2
        )

        row = 2
        for scan in self.body.getOrganicScans(ScanOrganic.SCAN_TYPE_LOG):
            name = scan.getSpeciesLocalised()
            if scan.getVariantLocalised() is not None and scan.getVariantLocalised() != "":
                name = scan.getVariantLocalised()

            dataLayout.addWidget(
                getContentLabel(name),
                row,
                0
            )
            row += 1

        row = 2
        for scan in self.body.getOrganicScans(ScanOrganic.SCAN_TYPE_ANALYSE):
            name = scan.getSpeciesLocalised()
            if scan.getVariantLocalised() is not None and scan.getVariantLocalised() != "":
                name = scan.getVariantLocalised()

            dataLayout.addWidget(
                getContentLabel(name),
                row,
                1
            )
            row += 1

        row = 2
        for codex in self.body.getCodexEntries(SSASignal.DB_TYPE_BIO):
            text = codex.getNameLocalised()
            if codex.isNewEntry():
                text += " " + QCoreApplication.translate("Systemview", "codex_new")

            dataLayout.addWidget(
                getContentLabel(text),
                row,
                2
            )
            row += 1

        self.setLayout(dataLayout)
