from package.Helper.UiHelper import *
from package.Journal.Events.Planet import Planet


class AtmosphereBox(QGroupBox):
    def __init__(self, planet: Planet, columns: int = 5):
        super().__init__(QCoreApplication.translate("Systemview", "atmosphere"))
        self.body = planet
        self.columns = columns

        self.init()

    def init(self) -> None:
        dataLayout = QGridLayout()
        dataLayout.addWidget(
            getDescLabel(QCoreApplication.translate("Systemview", "atmosphere_type")),
            0,
            0
        )

        dataLayout.addWidget(
            getContentLabel(
                self.body.getAtmosphere()),
            0,
            1
        )

        row = 1
        column = 0
        for element in self.body.getAtmosphereComposition():
            dataLayout.addWidget(
                getDescLabel(
                    QCoreApplication.translate("Systemview", element.getName()) + ":"
                ),
                row,
                column
            )

            column += 1

            dataLayout.addWidget(
                getContentLabel(element.getPercentAsString()),
                row,
                column
            )

            column += 1

            if column > self.columns:
                row += 1
                column = 0

        self.setLayout(dataLayout)
