from package.Datareader.StarReader import StarReader
from package.Journal.Events.Star import Star
from package.Journal.Events.SSASignal import SSASignal
from package.Config.ConfigManager import ConfigManager


class StarService:
    def __init__(self):
        self.reader = StarReader()

    def getStarsForSystem(self, systemAddress):
        stars = []

        starsData = self.reader.getStarsForSystem(systemAddress)
        for entry in starsData:
            rings = self.reader.getRingsForStar(entry['id'])

            star = Star()
            star.initFromDatabase(entry)
            star.initRingsFromDatabase(rings)
            star.setTemperatureFormat(ConfigManager.getConfigValue("temperature_format"))

            self.appendAdditionalStarData(star)
            stars.append(star)

        return stars

    def getMainStar(self, systemAddress):
        data = self.reader.getMainStarData(systemAddress)
        if data is None:
            return None

        star = Star()
        star.initFromDatabase(data)
        star.setTemperatureFormat(ConfigManager.getConfigValue("temperature_format"))
        return star

    def getFromData(self, starsData):
        stars = []

        for entry in starsData:
            rings = self.reader.getRingsForStar(entry['id'])

            star = Star()
            star.initFromDatabase(entry)
            star.initRingsFromDatabase(rings)
            star.setTemperatureFormat(ConfigManager.getConfigValue("temperature_format"))
            stars.append(star)

        return stars

    def appendAdditionalStarData(self, star: Star):
        ssaRings = self.reader.getSsaSignalsForRing(star.getInternalId())
        rings = star.getRings()

        if len(ssaRings) > 0:
            for entry in ssaRings:
                ssa = SSASignal()
                ssa.initFromDatabase(entry)

                for ring in rings:
                    if ring.getInternalId() == entry['ring_id']:
                        ring.addSsaSignal(ssa)
