from package.Datareader.RuleReader import RuleReader
from package.Database.DbFactory import DbFactory


class RuleService:
    def __init__(self):
        self.db = DbFactory.getDatabase()
        self.reader = RuleReader()

    def getAllRules(self):
        return self.reader.getAllRules()

    def createRule(self, name):
        data = {
            'name': name
        }

        ruleId = self.db.insert('worth_scanning_rule', data)
        return ruleId

    def deleteRule(self, ruleId):
        self.deleteChecksForRule(ruleId)
        self.db.delete('worth_scanning_rule', {'id': ruleId})

    def deleteChecksForRule(self, ruleId):
        self.db.delete('worth_scanning_check', {'rule_id': ruleId})

    def checkIfRuleExists(self, name):
        result = self.reader.getRuleByName(name)
        if result == []:
            return False
        else:
            return True

    def getChecksForRule(self, ruleId):
        return self.reader.getChecksForRule(ruleId)

    def deleteRuleCheck(self, rule):
        self.db.delete("worth_scanning_check", rule)

    def createCheckForRule(self, ruleId, field, value, operator):
        data = {
            "rule_id": ruleId,
            "field": field,
            "value": value,
            "operator": operator
        }

        self.db.insert("worth_scanning_check", data)
