class SystemState:
    _instance = None

    def __init__(self):
        self.system = {}
        self.systemComplete = False
        self.nextStarClass = None
        self.nextStarSystem = None
        self.currentSystem = None
        self.objectsWorthScanning = {}
        self.posZ = 0
        self.bodyCount = 0
        self.bodySignals = {}
        self.sellExplorationDataAmount = 0

        SystemState._instance = self

    @staticmethod
    def getInstance():
        """ Fake singleton for now """
        if SystemState._instance == None:
            SystemState()
        return SystemState._instance

    def getSystem(self):
        return self.system

    def addBody(self, body):
        bodyId = body.getBodyId()
        self.system[bodyId] = body

    def getCount(self):
        return len(self.system)

    def reset(self):
        self.system = {}
        self.systemComplete = False
        self.nextStarClass = None
        self.nextStarSystem = None
        self.currentSystem = None
        self.objectsWorthScanning = {}
        self.posZ = 0
        self.bodyCount = 0
        self.bodySignals = {}

    def resetSystem(self):
        self.system = {}
        self.bodySignals = {}

    def clearObjectsWorthScanning(self):
        self.objectsWorthScanning = {}

    def setCurrentSystem(self, currentSystem):
        self.currentSystem = currentSystem

    def getCurrentSystem(self):
        return self.currentSystem

    def getNextStarClass(self):
        return self.nextStarClass

    def setNextStarClass(self, starClass):
        self.nextStarClass = starClass

    def getNextStarSystem(self):
        return self.nextStarSystem

    def setNextStarSystem(self, system):
        self.nextStarSystem = system

    def getObjectsWorthScanning(self):
        return self.objectsWorthScanning

    def isSetObjectWorthScanning(self, number):
        return number in self.objectsWorthScanning

    def addWorthScanning(self, number, bodyType, distance, terraformable, detailScan):
        self.objectsWorthScanning[number] = {
            "number": number,
            "type": bodyType,
            "distance": distance,
            "isTerraformable": terraformable,
            "detailScan": detailScan
        }

    def updateObjectWorthScanning(self, number, detailScan):
        self.objectsWorthScanning[number]['detailScan'] = detailScan

    def isSystemComplete(self):
        return self.systemComplete

    def setSystemComplete(self, status):
        self.systemComplete = status

    def setPosZ(self, pos):
        self.posZ = pos

    def getPosZ(self):
        return self.posZ

    def setBodyCount(self, count):
        self.bodyCount = count

    def getBodyCount(self):
        return self.bodyCount

    def addBodySignalEvent(self, key, event):
        self.bodySignals[key] = event

    def getBodySignalEvent(self, key):
        bodySignal = None
        if key in self.bodySignals:
            bodySignal = self.bodySignals[key]

        return bodySignal

    def removeBodySignalEvent(self, key):
        self.bodySignals.pop(key, None)

    def addExplorationAmount(self, value):
        self.sellExplorationDataAmount = self.sellExplorationDataAmount + value

    def getExplorationAmount(self):
        return self.sellExplorationDataAmount

    def resetExplorationAmount(self):
        self.sellExplorationDataAmount = 0
