from package.Journal.Events.Star import Star
from package.Journal.Events.Planet import Planet


class SessionStatisticHandler:
    _instance = None

    def __init__(self):
        self.jumps = 0
        self.distance = 0
        self.fuelUsed = 0
        self.starScanCount = 0
        self.planetScanCount = 0
        self.detailScanCount = 0
        self.organicScans = 0

        SessionStatisticHandler._instance = self

    @staticmethod
    def getInstance():
        """ Fake singleton for now """
        if SessionStatisticHandler._instance == None:
            SessionStatisticHandler()
        return SessionStatisticHandler._instance

    def addJumpData(self, data):
        # called for every fsd jump
        self.jumps += 1
        self.distance += data.getJumpDistance()
        self.fuelUsed += data.getFuelUsed()

    def addDetailScan(self):
        self.detailScanCount += 1

    def addScanData(self, body):
        if isinstance(body, Star):
            self.starScanCount += 1
        elif isinstance(body, Planet):
            self.planetScanCount += 1

    def addOrganicScan(self):
        self.organicScans += 1

    def getJumps(self):
        return self.jumps

    def getDistance(self):
        return self.distance

    def getFuelUsed(self):
        return self.fuelUsed

    def getStarScanCout(self):
        return self.starScanCount

    def getPlanetScanCount(self):
        return self.planetScanCount

    def getDetailScanCount(self):
        return self.detailScanCount

    def getOrganicScanCount(self):
        return self.organicScans
