class ObserverMessage:
    OBSERVER_DESTINATION_POSITION = "POSITION"
    OBSERVER_DESTINATION_ERROR = "ERROR"
    OBSERVER_DESTINATION_STATUS = "STATUS"
    OBSERVER_DESTINATION_CHECKLOG = "CHECKLOG"
    OBSERVER_DESTINATION_MAINSTAR = "MAINSTAR"
    OBSERVER_DESTINATION_WORTHSCANNING = "WORTHSCANNING"
    OBSERVER_DESTINATION_CALCULATION = "CALCULATION"
    OBSERVER_DESTINATION_CONTINUED = "CONTINUED"
    OBSERVER_DESTINATION_NOTIFY_WORTHSCANNING = "NOTIFY_WORTH_SCANNING"
    OBSERVER_DESTINATION_BIO_CALCULATION = "BIO_CALCULATION"

    def __init__(self, destination, data=None):
        self.destination = destination
        self.data = data

    @classmethod
    def createNotifyWorthScanningMessage(cls, text):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_NOTIFY_WORTHSCANNING,
            {"message": text}
        )

    @classmethod
    def createPositionMessage(cls, data):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_POSITION,
            data
        )

    @classmethod
    def createErrorMessage(cls, errorMessage):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_ERROR,
            {"error": errorMessage}
        )

    @classmethod
    def createStatusMessage(cls, message):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_STATUS,
            {"message": message}
        )

    @classmethod
    def createCheckMessage(cls, data):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_CHECKLOG,
            data
        )

    # data is the complete json scan event
    @classmethod
    def createMainStarMessage(cls, data):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_MAINSTAR,
            data
        )

    @classmethod
    def createWorthScanningMessage(cls, data):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_WORTHSCANNING,
            data
        )

    @classmethod
    def createCalculationMessage(cls, sessionValue, totalValue):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_CALCULATION,
            {
                'sessionValue': sessionValue,
                'totalValue': totalValue
            }
        )

    @classmethod
    def createContinuedMessage(cls):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_CONTINUED,
            {}
        )

    @classmethod
    def createBioCalculationMessage(cls, sessionValue, totalValue):
        return ObserverMessage(
            ObserverMessage.OBSERVER_DESTINATION_BIO_CALCULATION,
            {
                'sessionValue': sessionValue,
                'totalValue': totalValue
            }
        )
