from package.Observer.CheckerAbstract import CheckerAbstract
from package.Observer.ObserverMessage import ObserverMessage
from package.Observer.CheckResult import CheckResult
from package.Journal.Events.Planet import Planet


class CheckerSystemAbstract(CheckerAbstract):
    CHECKER_TYPE = CheckerAbstract.CHECKER_TYPE_SYSTEM

    def __init__(self):
        self.system = None
        self.results = []
        self.alreadyScanned = []
        super().__init__()

    def check(self, systemState):
        super().check()
        self.results = []
        self.alreadyScanned = []
        self.systemState = systemState

    def getMoons(self, bodyId):
        moons = []

        system = self.systemState.getSystem()

        for i in system:
            body = system[i]
            if isinstance(body, Planet):
                parentId = body.getParentPlanet()
                if bodyId == parentId:
                    moons.append(system[i])

        return moons

    def addMessage(self, message, body):
        checkResult = CheckResult()
        checkResult.found = True
        checkResult.message = message
        checkResult.body = body

        self.results.append(ObserverMessage.createCheckMessage(
            checkResult
        ))
