from PyQt5.QtCore import QCoreApplication
from package.Observer.CheckerAbstract import CheckerAbstract
from package.Journal.Events.Planet import Planet


class CheckWorldTemperature(CheckerAbstract):
    # mandatory definition: this is a body checker
    CHECKER_TYPE = CheckerAbstract.CHECKER_TYPE_BODY

    def check(self, body):
        super().check(body)

        if not isinstance(body, Planet) or (body.getType() != 'Water world' and body.getType() != 'Earthlike body'):
            return self.result

        tempCelsius = body.getTemperatureAsString()
        planetClassTranslated = QCoreApplication.translate("BodyTypes", body.getType())

        message = self.translate("checker_world_temperature").format(planetClassTranslated, tempCelsius)

        self.result.found = True
        self.result.body = body.getName()
        self.result.message = message

        return self.result
