from package.Observer.CheckerAbstract import CheckerAbstract


class CheckWideRings(CheckerAbstract):
    # mandatory definition: this is a body checker
    CHECKER_TYPE = CheckerAbstract.CHECKER_TYPE_BODY

    CONFIG_NAME_RING_WIDTH = "ring_width"

    def check(self, body):
        super().check(body)

        criteriaRingWidth = int(self.getConfigValue(self.CONFIG_NAME_RING_WIDTH)) * 1000

        if body.hasRings():
            for ring in body.getRings():
                if ring.getRingWidth() > criteriaRingWidth:
                    self.result.found = True
                    self.result.body = body.getName()

                    ringTypeTranslated = self.translate(ring.getType(), "BodyTypes")

                    message = self.translate("checker_wide_rings").format(
                        ringTypeTranslated,
                        ring.getRingWidthAsString(),
                        body.getRadiusAsString()
                    )
                    self.result.message = message

        return self.result

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'float',
                'name': self.CONFIG_NAME_RING_WIDTH,
                'value': self.getConfigValue(self.CONFIG_NAME_RING_WIDTH)
            }
        ]
