from package.Observer.CheckerAbstract import CheckerAbstract
from package.Journal.Events.Planet import Planet


class CheckWaterGiants(CheckerAbstract):
    CONFIG_NAME_RADIUS = "radius"
    CONFIG_NAME_MASS = "mass"

    # check criteria
    CRITERIA_RADIUS = 30500
    CRITERIA_MASS = 100

    def check(self, body):
        super().check(body)

        criteriaRadius = int(self.getConfigValue(self.CONFIG_NAME_RADIUS))
        criteriaMass = int(self.getConfigValue(self.CONFIG_NAME_MASS))

        if not isinstance(body, Planet) or body.getType() != 'Water giant':
            return self.result

        message = ""
        radius = body.getRadius() / 1000
        massEM = body.getMass()

        if radius > criteriaRadius:
            message += self.translate("checker_water_giants_radius").format(body.getRadiusAsString())
            message += "<br>"
        if massEM > criteriaMass:
            message += self.translate("checker_water_giants_mass").format(body.getMassAsString())

        if message != "":
            self.result.found = True
            self.result.body = body.getName()
            self.result.message = message

        return self.result

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'int',
                'name': self.CONFIG_NAME_RADIUS,
                'value': self.getConfigValue(self.CONFIG_NAME_RADIUS)
            },
            {
                'type': 'int',
                'name': self.CONFIG_NAME_MASS,
                'value': self.getConfigValue(self.CONFIG_NAME_MASS)
            }
        ]
