from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract


class CheckWaterGiantWithWaterWorldMoon(CheckerSystemAbstract):
    def check(self, systemState):
        super().check(systemState)

        system = self.systemState.getSystem()
        for i in system:
            body = system[i]
            if body.getType() == 'Water world':
                parentId = body.getParentPlanet()
                if (parentId is not None) and (parentId in system):
                    parent = system[parentId]
                    if parent.getType() == "Water giant":
                        self.addMessage(
                            self.translate("checker_water_giant_with_water_world_moon"),
                            body.getName()
                        )

        return self.results
