from typing import List
from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Journal.Events.BodyEntity import BodyEntity


class CheckTrojan(CheckerSystemAbstract):
    def check(self, systemState):
        super().check(systemState)

        possibleTrojans = []
        objects = self.getObjects()

        if len(objects) < 2:
            return self.results

        for object in objects:
            for tmp in self.getObjects(object):
                if object.getSemiMajorAxis() != tmp.getSemiMajorAxis():
                    continue

                if tmp.getName() in possibleTrojans:
                    continue

                # this should apply to stars orbiting each other
                if object.getParentPlanet() is None and object.getParentStar() is None:
                    continue

                # check other orbital data
                if object.getEccentricity() == tmp.getEccentricity() and object.getInclination() == tmp.getInclination():
                    possibleTrojans.append(object.getName())
                    possibleTrojans.append(tmp.getName())

                    self.addMessage(
                        self.translate("checker_trojan").format(
                            object.getName(),
                            tmp.getName()
                        ),
                        object.getName()
                    )

        return self.results

    def getObjects(self, skip: BodyEntity = None) -> List[BodyEntity]:
        objects = []
        system = self.systemState.getSystem()

        for bodyId in system:
            if skip is None:
                objects.append(system[bodyId])
            elif system[bodyId].getName() != skip.getName():
                objects.append(system[bodyId])

        return objects
