from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Database.DbFactory import DbFactory


class CheckSystemRecords(CheckerSystemAbstract):
    def __init__(self):
        super().__init__()

        self.maxZ = 0
        self.minZ = 0
        self.maxBodies = 0
        self.initRecords()

    def check(self, systemState):
        super().check(systemState)

        # 'highest' & lowest system
        if self.systemState.getPosZ() > self.maxZ:
            self.addMessage(
                self.translate("checker_system_record_highest").format(self.systemState.getPosZ()),
                systemState.getCurrentSystem()
            )
            self.maxZ = self.systemState.getPosZ()

        if self.systemState.getPosZ() < self.minZ:
            self.addMessage(
                self.translate("checker_system_record_lowest").format(self.systemState.getPosZ()),
                self.systemState.getCurrentSystem()
            )
            self.minZ = self.systemState.getPosZ()

        if self.systemState.getBodyCount() > self.maxBodies:
            self.addMessage(
                self.translate("checker_system_record_body_count").format(self.systemState.getBodyCount()),
                self.systemState.getCurrentSystem()
            )
            self.maxBodies = self.systemState.getBodyCount()

        return self.results

    def initRecords(self):
        db = DbFactory.getDatabase()
        result = db.select("systems", ["MAX(pos_z) as max_z, MIN(pos_z) as min_z, MAX(body_count) as body_count", ], {})

        if result[0]["max_z"] is not None:
            self.maxZ = result[0]["max_z"]

        if result[0]["min_z"] is not None:
            self.minZ = result[0]["min_z"]

        if result[0]["body_count"] is not None:
            self.maxBodies = result[0]["body_count"]
