from package.Observer.CheckerAbstract import CheckerAbstract
from package.Journal.Events.Planet import Planet


class CheckSmallBody(CheckerAbstract):
    # mandatory definition: this is a body checker
    CHECKER_TYPE = CheckerAbstract.CHECKER_TYPE_BODY

    CONFIG_NAME_MIN_RADIUS = "min_radius"

    def check(self, body):
        super().check(body)

        criteriaMinRadius= int(self.getConfigValue(self.CONFIG_NAME_MIN_RADIUS))

        if not isinstance(body, Planet):
            return self.result

        radius = body.getRadius() / 1000
        if 0 < radius < criteriaMinRadius:
            self.result.found = True
            self.result.body = body.getName()
            self.result.message = self.translate("checker_small_radius").format(body.getRadiusAsString())
            if body.isLandable():
                self.result.message += " " + self.translate("landable")

        return self.result

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'int',
                'name': self.CONFIG_NAME_MIN_RADIUS,
                'value': self.getConfigValue(self.CONFIG_NAME_MIN_RADIUS)
            }
        ]
