from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Elite.StarTypes import StarTypes
from package.Elite.PlanetTypes import PlanetTypes
from PyQt5.QtCore import QCoreApplication


class CheckRareWaterWorlds(CheckerSystemAbstract):
    def check(self, systemState):
        super().check(systemState)

        veryRareMainStarTypes = [
            StarTypes.TYPES['TYPE_O'],
            StarTypes.TYPES['TYPE_A_GIANT'],
            StarTypes.TYPES['TYPE_B_GIANT'],
            StarTypes.TYPES['TYPE_F_GIANT'],
            StarTypes.TYPES['TYPE_G_GIANT'],
            StarTypes.TYPES['TYPE_M_SUPER_GIANT'],
            StarTypes.TYPES['TYPE_W'],
            StarTypes.TYPES['TYPE_WN'],
            StarTypes.TYPES['TYPE_WNC'],
            StarTypes.TYPES['TYPE_WC'],
            StarTypes.TYPES['TYPE_WO'],
        ]

        rareMainStarTypes = [
            StarTypes.TYPES['TYPE_CJ'],
            StarTypes.TYPES['TYPE_H'],
            StarTypes.TYPES['TYPE_MS'],
            StarTypes.TYPES['TYPE_CN'],
            StarTypes.TYPES['TYPE_K_GIANT'],
        ]

        veryRarePlanetParentTypes = [
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_I'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_V'],
            PlanetTypes.TYPES['TYPE_GAS_GIANT_AMMONIA_LIFE'],
            PlanetTypes.TYPES['TYPE_ICE'],
            PlanetTypes.TYPES['TYPE_ROCKY_ICE'],
            PlanetTypes.TYPES['TYPE_WATER_GIANT'],
            PlanetTypes.TYPES['TYPE_AMMONIA_WORLD'],
            PlanetTypes.TYPES['TYPE_METAL_RICH'],
        ]

        rarePlanetParentTypes = [
            PlanetTypes.TYPES['TYPE_HELIUM_RICH'],
            PlanetTypes.TYPES['TYPE_EARTHLIKE'],
            PlanetTypes.TYPES['TYPE_GAS_GIANT_WATER_LIFE'],
        ]

        system = self.systemState.getSystem()
        for i in system:
            messages = []
            body = system[i]
            planetClass = body.getType()

            if planetClass == PlanetTypes.TYPES['TYPE_WATER_WORLD']:
                planetClassTranslated = QCoreApplication.translate("BodyTypes", planetClass)

                # check parent star types
                starId = body.getParentStar()

                if (starId is not None) and (starId in system):
                    mainStar = system[starId]
                    starType = mainStar.getType()

                    rarePostfix = None
                    if starType in veryRareMainStarTypes:
                        rarePostfix = self.translate("very rare")

                    if starType in rareMainStarTypes:
                        rarePostfix = self.translate("rare")

                    if rarePostfix is not None:
                        starClassTranslated = QCoreApplication.translate("BodyTypes", starType)
                        messages.append(self.translate("checker_rare_star_parent").format(planetClassTranslated, starClassTranslated, rarePostfix))

                # check parent planet types
                parentId = body.getParentPlanet()

                if (parentId is not None) and (parentId in system):
                    parent = system[parentId]
                    parentPlanetClass = parent.getType()

                    rarePostfix = None
                    if parentPlanetClass in veryRarePlanetParentTypes:
                        rarePostfix = self.translate("very rare")

                    if parentPlanetClass in rarePlanetParentTypes:
                        rarePostfix = self.translate("rare")

                    if rarePostfix is not None:
                        parentPlanetClassTranslated = QCoreApplication.translate("BodyTypes", parentPlanetClass)
                        messages.append(self.translate("checker_rare_planet_parent").format(planetClassTranslated, parentPlanetClassTranslated, rarePostfix))

                rarePostfix = self.translate("very rare")

                # check radius
                radius = body.getRadius()
                if radius >= 28500000:
                    messages.append(self.translate("checker_rare_planet_radius").format(planetClassTranslated, body.getRadiusAsString(2), rarePostfix))

                # check mass
                mass = body.getMass()
                if mass >= 350:
                    messages.append(self.translate("checker_rare_planet_mass").format(planetClassTranslated, body.getMassAsString(2), rarePostfix))

                # check temperature
                temp = body.getTemperature()
                if temp >= 900:
                    messages.append(self.translate("checker_rare_planet_temperature").format(planetClassTranslated, body.getTemperatureAsString(2), rarePostfix))

                # rotation period
                rotation = abs(body.getRotationPeriod())
                if rotation <= 8640:
                    messages.append(self.translate("checker_rare_planet_roation_period").format(planetClassTranslated, body.getRotationPeriodAsString(), rarePostfix))

            if len(messages) > 0:
                self.addMessage(
                    '<br>'.join(messages),
                    body.getName()
                )

        return self.results
