from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Elite.StarTypes import StarTypes
from package.Elite.PlanetTypes import PlanetTypes
from PyQt5.QtCore import QCoreApplication


class CheckRareWaterGiants(CheckerSystemAbstract):
    def check(self, systemState):
        super().check(systemState)

        veryRareMainStarTypes = [
            StarTypes.TYPES['TYPE_B'],
            StarTypes.TYPES['TYPE_K_GIANT'],
            StarTypes.TYPES['TYPE_M_GIANT'],
            StarTypes.TYPES['TYPE_W'],
            StarTypes.TYPES['TYPE_WN'],
            StarTypes.TYPES['TYPE_WNC'],
            StarTypes.TYPES['TYPE_WC'],
            StarTypes.TYPES['TYPE_WO'],
            StarTypes.TYPES['TYPE_D'],
            StarTypes.TYPES['TYPE_DA'],
            StarTypes.TYPES['TYPE_DAB'],
            StarTypes.TYPES['TYPE_DAO'],
            StarTypes.TYPES['TYPE_DAZ'],
            StarTypes.TYPES['TYPE_DAV'],
            StarTypes.TYPES['TYPE_DB'],
            StarTypes.TYPES['TYPE_DBZ'],
            StarTypes.TYPES['TYPE_DBV'],
            StarTypes.TYPES['TYPE_DO'],
            StarTypes.TYPES['TYPE_DOV'],
            StarTypes.TYPES['TYPE_DQ'],
            StarTypes.TYPES['TYPE_DC'],
            StarTypes.TYPES['TYPE_DCV'],
            StarTypes.TYPES['TYPE_DX'],
        ]

        rareMainStarTypes = [
            StarTypes.TYPES['TYPE_H'],
            StarTypes.TYPES['TYPE_TTS'],
        ]

        system = self.systemState.getSystem()
        for i in system:
            messages = []
            body = system[i]
            planetClass = body.getType()

            if planetClass == PlanetTypes.TYPES['TYPE_WATER_GIANT'] or planetClass == PlanetTypes.TYPES['TYPE_WATER_GIANT_LIFE']:
                planetClassTranslated = QCoreApplication.translate("BodyTypes", planetClass)

                # check parent star types
                starId = body.getParentStar()

                if (starId is not None) and (starId in system):
                    mainStar = system[starId]
                    starType = mainStar.getType()

                    rarePostfix = None
                    if starType in veryRareMainStarTypes:
                        rarePostfix = self.translate("very rare")

                    if starType in rareMainStarTypes:
                        rarePostfix = self.translate("rare")

                    if rarePostfix is not None:
                        starClassTranslated = QCoreApplication.translate("BodyTypes", starType)
                        messages.append(self.translate("checker_rare_star_parent").format(planetClassTranslated, starClassTranslated, rarePostfix))

                rarePostfix = self.translate("very rare")

                # check mass
                mass = body.getMass()
                if mass >= 1000 or mass <= 17:
                    messages.append(self.translate("checker_rare_planet_mass").format(planetClassTranslated, body.getMassAsString(2), rarePostfix))

                # check high radius
                radius = body.getRadius()
                if radius >= 30500000 or radius <= 16000000:
                    messages.append(self.translate("checker_rare_planet_radius").format(planetClassTranslated, body.getRadiusAsString(2), rarePostfix))

            if len(messages) > 0:
                self.addMessage(
                    '<br>'.join(messages),
                    body.getName()
                )

        return self.results
