from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Elite.StarTypes import StarTypes
from package.Elite.PlanetTypes import PlanetTypes
from PyQt5.QtCore import QCoreApplication


class CheckRareClassV(CheckerSystemAbstract):
    def check(self, systemState):
        super().check(systemState)

        veryRareMainStarTypes = [
            StarTypes.TYPES['TYPE_C'],
            StarTypes.TYPES['TYPE_CN'],
            StarTypes.TYPES['TYPE_Y'],
            StarTypes.TYPES['TYPE_H'],
            StarTypes.TYPES['TYPE_MS'],
            StarTypes.TYPES['TYPE_S'],
            StarTypes.TYPES['TYPE_M_SUPER_GIANT'],
            StarTypes.TYPES['TYPE_B_GIANT'],
            StarTypes.TYPES['TYPE_M_GIANT'],
            StarTypes.TYPES['TYPE_WC'],
            StarTypes.TYPES['TYPE_WO'],
        ]

        rareMainStarTypes = [
            StarTypes.TYPES['TYPE_W'],
            StarTypes.TYPES['TYPE_WN'],
            StarTypes.TYPES['TYPE_WNC'],
            StarTypes.TYPES['TYPE_WC'],
            StarTypes.TYPES['TYPE_WO'],
            StarTypes.TYPES['TYPE_D'],
            StarTypes.TYPES['TYPE_DA'],
            StarTypes.TYPES['TYPE_DAB'],
            StarTypes.TYPES['TYPE_DAO'],
            StarTypes.TYPES['TYPE_DAZ'],
            StarTypes.TYPES['TYPE_DAV'],
            StarTypes.TYPES['TYPE_DB'],
            StarTypes.TYPES['TYPE_DBZ'],
            StarTypes.TYPES['TYPE_DBV'],
            StarTypes.TYPES['TYPE_DO'],
            StarTypes.TYPES['TYPE_DOV'],
            StarTypes.TYPES['TYPE_DQ'],
            StarTypes.TYPES['TYPE_DC'],
            StarTypes.TYPES['TYPE_DCV'],
            StarTypes.TYPES['TYPE_DX'],
            StarTypes.TYPES['TYPE_TTS'],
            StarTypes.TYPES['TYPE_AEBE'],
            StarTypes.TYPES['TYPE_G_GIANT'],
            StarTypes.TYPES['TYPE_K_GIANT'],
            StarTypes.TYPES['TYPE_F_GIANT'],
            StarTypes.TYPES['TYPE_L'],
            StarTypes.TYPES['TYPE_A_GIANT'],
        ]

        system = self.systemState.getSystem()
        for i in system:
            messages = []
            body = system[i]
            planetClass = body.getType()

            if planetClass == PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_V']:
                planetClassTranslated = QCoreApplication.translate("BodyTypes", planetClass)

                # check parent star types
                starId = body.getParentStar()

                if (starId is not None) and (starId in system):
                    mainStar = system[starId]
                    starType = mainStar.getType()

                    rarePostfix = None
                    if starType in veryRareMainStarTypes:
                        rarePostfix = self.translate("very rare")

                    if starType in rareMainStarTypes:
                        rarePostfix = self.translate("rare")

                    if rarePostfix is not None:
                        starClassTranslated = QCoreApplication.translate("BodyTypes", starType)
                        messages.append(self.translate("checker_rare_star_parent").format(planetClassTranslated, starClassTranslated, rarePostfix))

                rarePostfix = self.translate("very rare")

                # check radius
                radius = body.getRadius()
                if radius >= 77800000 or radius <= 21100000:
                    value = radius / 1000
                    messages.append(self.translate("checker_rare_planet_radius").format(planetClassTranslated, body.getRadiusAsString(2), rarePostfix))

                # check mass
                mass = body.getMass()
                if mass >= 4000 or mass <= 33:
                    messages.append(self.translate("checker_rare_planet_mass").format(planetClassTranslated, body.getMassAsString(2), rarePostfix))

                # check temperature
                temp = body.getTemperature()
                if temp >= 11100 or temp <= 1400:
                    messages.append(self.translate("checker_rare_planet_temperature").format(planetClassTranslated, body.getTemperatureAsString(2), rarePostfix))

                # rotation period
                rotation = abs(body.getRotationPeriod())
                if rotation <= 8640:
                    messages.append(self.translate("checker_rare_planet_roation_period").format(planetClassTranslated, body.getRotationPeriodAsString(), rarePostfix))

                # oribtal period
                orbital = abs(body.getOrbitalPeriod())
                if orbital >= 69120000 or orbital <= 960:
                    messages.append(self.translate("checker_rare_planet_orbital_period").format(planetClassTranslated, body.getOrbitalPeriodAsString(), rarePostfix))

            if len(messages) > 0:
                self.addMessage(
                    '<br>'.join(messages),
                    body.getName()
                )

        return self.results
