from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Elite.StarTypes import StarTypes
from package.Elite.PlanetTypes import PlanetTypes
from PyQt5.QtCore import QCoreApplication


class CheckRareAmmoniaWorlds(CheckerSystemAbstract):
    def check(self, systemState):
        super().check(systemState)

        veryRareMainStarTypes = [
            StarTypes.TYPES['TYPE_CN'],
            StarTypes.TYPES['TYPE_W'],
            StarTypes.TYPES['TYPE_WN'],
            StarTypes.TYPES['TYPE_WNC'],
            StarTypes.TYPES['TYPE_WC'],
            StarTypes.TYPES['TYPE_WO'],
            StarTypes.TYPES['TYPE_MS'],
            StarTypes.TYPES['TYPE_S'],
            StarTypes.TYPES['TYPE_K_GIANT'],
        ]

        rareMainStarTypes = [
            StarTypes.TYPES['TYPE_H'],
            StarTypes.TYPES['TYPE_D'],
            StarTypes.TYPES['TYPE_DA'],
            StarTypes.TYPES['TYPE_DAB'],
            StarTypes.TYPES['TYPE_DAO'],
            StarTypes.TYPES['TYPE_DAZ'],
            StarTypes.TYPES['TYPE_DAV'],
            StarTypes.TYPES['TYPE_DB'],
            StarTypes.TYPES['TYPE_DBZ'],
            StarTypes.TYPES['TYPE_DBV'],
            StarTypes.TYPES['TYPE_DO'],
            StarTypes.TYPES['TYPE_DOV'],
            StarTypes.TYPES['TYPE_DQ'],
            StarTypes.TYPES['TYPE_DC'],
            StarTypes.TYPES['TYPE_DCV'],
            StarTypes.TYPES['TYPE_DX'],
        ]

        veryRarePlanetParentTypes = [
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_V'],
            PlanetTypes.TYPES['TYPE_GAS_GIANT_AMMONIA_LIFE'],
            PlanetTypes.TYPES['TYPE_HELIUM_RICH'],
            PlanetTypes.TYPES['TYPE_ICE'],
        ]

        rarePlanetParentTypes = [
            PlanetTypes.TYPES['TYPE_WATER_GIANT'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_I'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_II'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_III'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_IV'],
            PlanetTypes.TYPES['TYPE_GAS_GIANT_WATER_LIFE'],
            PlanetTypes.TYPES['TYPE_WATER_WORLD'],
        ]

        system = self.systemState.getSystem()
        for i in system:
            messages = []
            body = system[i]
            planetClass = body.getType()

            if planetClass == PlanetTypes.TYPES['TYPE_AMMONIA_WORLD']:
                planetClassTranslated = QCoreApplication.translate("BodyTypes", planetClass)

                # check parent star types
                starId = body.getParentStar()

                if (starId is not None) and (starId in system):
                    mainStar = system[starId]
                    starType = mainStar.getType()

                    rarePostfix = None
                    if starType in veryRareMainStarTypes:
                        rarePostfix = self.translate("very rare")

                    if starType in rareMainStarTypes:
                        rarePostfix = self.translate("rare")

                    if rarePostfix is not None:
                        starClassTranslated = QCoreApplication.translate("BodyTypes", starType)
                        messages.append(self.translate("checker_rare_star_parent").format(planetClassTranslated, starClassTranslated, rarePostfix))

                # check parent planet types
                parentId = body.getParentPlanet()

                if (parentId is not None) and (parentId in system):
                    parent = system[parentId]
                    parentPlanetClass = parent.getType()

                    rarePostfix = None
                    if parentPlanetClass in veryRarePlanetParentTypes:
                        rarePostfix = self.translate("very rare")

                    if parentPlanetClass in rarePlanetParentTypes:
                        rarePostfix = self.translate("rare")

                    if rarePostfix is not None:
                        parentPlanetClassTranslated = QCoreApplication.translate("BodyTypes", parentPlanetClass)
                        messages.append(self.translate("checker_rare_planet_parent").format(planetClassTranslated, parentPlanetClassTranslated, rarePostfix))

                rarePostfix = self.translate("very rare")

                # check mass
                mass = body.getMass()
                if mass >= 800:
                    messages.append(self.translate("checker_rare_planet_mass").format(planetClassTranslated, body.getMassAsString(), rarePostfix))

            if len(messages) > 0:
                self.addMessage(
                    '<br>'.join(messages),
                    body.getName()
                )

        return self.results
