from package.Observer.CheckerAbstract import CheckerAbstract


class CheckNarrowRings(CheckerAbstract):
    CONFIG_NAME_RING_WIDTH = "ring_width"

    def check(self, body):
        super().check(body)

        criteriaRingWidth = int(self.getConfigValue(self.CONFIG_NAME_RING_WIDTH))

        if body.hasRings():
            for ring in body.getRings():
                if ring.getRingWidth() < (criteriaRingWidth * 1000):
                    ringTypeTranslated = self.translate(ring.getType(), "BodyTypes")

                    self.result.found = True
                    self.result.body = body.getName()
                    self.result.message = self.translate("checker_narrow_ring").format(
                        ringTypeTranslated,
                        ring.getRingWidthAsString()
                    )

        return self.result

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'int',
                'name': self.CONFIG_NAME_RING_WIDTH,
                'value': self.getConfigValue(self.CONFIG_NAME_RING_WIDTH)
            }
        ]
