from package.Observer.CheckerAbstract import CheckerAbstract
from package.Journal.Events.Planet import Planet


class CheckMaterials(CheckerAbstract):
    # mandatory definition: this is a body checker
    CHECKER_TYPE = CheckerAbstract.CHECKER_TYPE_BODY

    CONFIG_NAME_ARSENIC_LEVEL = "arsenic"
    CONFIG_NAME_POLONIUM_LEVEL = "polonium"
    CONFIG_NAME_GERMANIUM_LEVEL = "germanium"
    CONFIG_NAME_SELENIUM_LEVEL = "selenium"

    def check(self, body):
        super().check(body)

        criteria = {
            self.CONFIG_NAME_ARSENIC_LEVEL: float(self.getConfigValue(self.CONFIG_NAME_ARSENIC_LEVEL)),
            self.CONFIG_NAME_POLONIUM_LEVEL: float(self.getConfigValue(self.CONFIG_NAME_POLONIUM_LEVEL)),
            self.CONFIG_NAME_GERMANIUM_LEVEL: float(self.getConfigValue(self.CONFIG_NAME_GERMANIUM_LEVEL)),
            self.CONFIG_NAME_SELENIUM_LEVEL: float(self.getConfigValue(self.CONFIG_NAME_SELENIUM_LEVEL)),
        }

        found = False
        messageAdd = ""

        if not isinstance(body, Planet) or body.isLandable() is False:
            return self.result

        for material in body.getMaterial():
            materialName = material.getName()

            if materialName in criteria:
                if material.getPercent() > criteria[materialName] and criteria[materialName] > 0:
                    found = True
                    messageAdd += material.getNameLocalised() + ": " + str(material.getPercentAsString()) + "\n"

        if found:
            self.result.found = True
            self.result.body = body.getName()
            self.result.message = self.translate("checker_material") + "\n"
            self.result.message += messageAdd

        return self.result

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'float',
                'name': self.CONFIG_NAME_ARSENIC_LEVEL,
                'value': self.getConfigValue(self.CONFIG_NAME_ARSENIC_LEVEL)
            },
            {
                'type': 'float',
                'name': self.CONFIG_NAME_POLONIUM_LEVEL,
                'value': self.getConfigValue(self.CONFIG_NAME_POLONIUM_LEVEL)
            },
            {
                'type': 'float',
                'name': self.CONFIG_NAME_GERMANIUM_LEVEL,
                'value': self.getConfigValue(self.CONFIG_NAME_GERMANIUM_LEVEL)
            },
            {
                'type': 'float',
                'name': self.CONFIG_NAME_SELENIUM_LEVEL,
                'value': self.getConfigValue(self.CONFIG_NAME_SELENIUM_LEVEL)
            }
        ]
