from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Helper.DataObject import DataObject


class CheckManySmallMoons(CheckerSystemAbstract):
    CONFIG_NAME_MOON_COUNT = "moon_count"
    CONFIG_NAME_MOON_RADIUS = "moon_radius"

    def check(self, systemState):
        super().check(systemState)

        moonCount = int(self.getConfigValue(self.CONFIG_NAME_MOON_COUNT))
        moonRadius = float(self.getConfigValue(self.CONFIG_NAME_MOON_RADIUS))

        system = self.systemState.getSystem()
        count = 0
        bodyName = ""
        for bodyId in system:
            body = system[bodyId]
            bodyId = body.getBodyId()

            if 'gas giant' in body.getType():
                moons = self.getMoons(bodyId)
                if len(moons) > moonCount:
                    for moon in moons:
                        radius = moon.getRadius() / 1000
                        if radius < moonRadius:
                            count += 1
                            bodyName = body.getSystemName()

        if count > moonCount:
            self.addMessage(
                self.translate("checker_many_small_moons").format(str(count)),
                bodyName
            )

        return self.results

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'int',
                'name': self.CONFIG_NAME_MOON_COUNT,
                'value': self.getConfigValue(self.CONFIG_NAME_MOON_COUNT)
            },
            {
                'type': 'int',
                'name': self.CONFIG_NAME_MOON_RADIUS,
                'value': self.getConfigValue(self.CONFIG_NAME_MOON_RADIUS)
            }
        ]
